using System;

public interface IDrawable
{
  void Draw();
}

public class Shape
{
  public virtual void Draw()
  {
    Console.WriteLine("Jestem jakimś kształtem.");
  }
}

public class Circle : Shape, IDrawable
{
  public override void Draw()
  {
    Console.WriteLine("Jestem okręgiem.");
  }
}

public class Rectangle : Shape, IDrawable
{
  public override void Draw()
  {
    Console.WriteLine("Jestem prostokątem.");
  }
}

public class Triangle : Shape, IDrawable
{
  public override void Draw()
  {
    Console.WriteLine("Jestem trójkątem.");
  }
}
